# Scan and execute simple expressions
from Stack import *


def prec(ch):  # Return the precedence of an operator
    if ch == '+' or ch == '-':
        return 1
    if ch == '*' or ch == '/':
        return 2
    if ch == '^':
        return 3
    if ch == '(':
        return 0
    if ch == ')':
        return 4
    else:
        error()


def digit(c):  # Is the character c a digit?
    if c >= '0' and c <= '9':
        return True
    else:
        return False


# Pop two operands and an operator, execute the operator, push the result
def execute():
    op2 = operand_stack.pop()
    op1 = operand_stack.pop()
    c = operator_stack.pop()
    if c == '+':
        if op1==None or op2==None:
            print("No unary operators")
            exit()
        res = op1 + op2
    elif c == '-':
        if op1==None or op2==None:
            print("No unary operators")
            exit()
        res = op1 - op2
    elif c == '*':
        res = op1 * op2
    elif c == '/':
        res = op1 / op2

    elif c == "^":
        res = op1 ** op2
    else:
        error()
        return
    operand_stack.push(res)


def error():
    print("error.")


def scan(s):
    i = 0                      # Current character is s[i]
    while i < len(s):          # Examine all characters
        if digit(s[i]):        # An operand?
            val = 0            # Numerical value of the number
            fval = 0           # Fractional part, as integer
            k = 0              # Fractional power of 10
            try:
                while digit(s[i]):           # Yes.
                    val = val*10 + int(s[i]) - int('0')     # Accumulate the integer part
                    i = i + 1
                if s[i] == '.':                              # Fraction?
                    i = i + 1
                    k = 0
                while digit(s[i]):  # Yes.
                    fval = fval * 10 + int(s[i]) - int('0')   # Accumulate the fractional part
                    i = i + 1
                    k = k + 1                              # How many fractional digits
            except IndexError:
                pass
            val = float(val) + float(fval)/(10**k)
            operand_stack.push(val)                 # Rule 1: Push the operand

        else:                                       # An operator
            if operator_stack.empty():              # Rule 2: push onto empty stack
                operator_stack.push(s[i])
            elif s[i] == '(':                       # Rule 3
                operator_stack.push(s[i])
            elif s[i] == ')':                       # Rule 4
                while not operator_stack.top() == '(':
                    execute()
                operator_stack.pop()
            else:                                   # Rule 5
                while not operator_stack.empty() and (prec(operator_stack.top()) >= prec(s[i])):
                    execute()
                operator_stack.push(s[i])
            i = i + 1
    while not operator_stack.empty():               # Rule 6
        execute()


operator_stack = Stack()   # Create the two stacks
operand_stack = Stack()
line = input()             # Read the expression
print(line, " = ", end="")
scan(line)                 # break it into components and execute
print(operand_stack.top())
